import os
from PIL import Image
from tqdm import tqdm

def resize_images_in_folder(folder_path):
    # 
    for file in files:

        if file.lower().endswith(('.png', '.jpg', '.jpeg', '.bmp', '.gif')):
 
            image_path = os.path.join(folder_path, file)


            with Image.open(image_path) as img:

                original_width, original_height = img.size


                new_size = (original_width // 2, original_height // 2)
                resized_img = img.resize(new_size, Image.LANCZOS)


                resized_img.save(image_path)

    print(f"Resized and saved in {folder_path}")


folder_path = ""  #


for root, dirs, files in tqdm(list(os.walk(folder_path)), desc="Processing folders", unit="folder"):
    resize_images_in_folder(root)  # 
